<?php

// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignaturesadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'administrator');
}

if (self::$db_alter->fetch_table_info('user'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignatures_configuration',
		'type'       => 'mediumtext',
		'null'       => true,	// True = NULL, false = NOT NULL
		'default'    => NULL
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignatures_points',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignatures_dateline',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignatures_signature',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));	
	self::report('Altered Table', 'user');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsignaturespermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_category` (
		`categoryid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`displayorder` int(10) unsigned NOT NULL DEFAULT '0',
		`description` mediumtext,
		`permissions` mediumtext,
		PRIMARY KEY (`categoryid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_category');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_font` (
		`fontid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`displayorder` int(10) unsigned NOT NULL DEFAULT '0',
		`fontfile_0` varchar(250) NOT NULL DEFAULT '',		
		`fontfile_1` varchar(250) NOT NULL DEFAULT '',		
		`fontfile_2` varchar(250) NOT NULL DEFAULT '',		
		`fontfile_3` varchar(250) NOT NULL DEFAULT '',		
		`cancustom` enum('0','1') NOT NULL DEFAULT '1',
		PRIMARY KEY (`fontid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_font');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_inventory` (
		`userid` int(10) unsigned NOT NULL,
		`partid` int(10) unsigned NOT NULL,
		PRIMARY KEY (`userid`, `partid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_inventory');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_layer` (
		`layerid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`displayorder` int(10) unsigned NOT NULL DEFAULT '0',
		`folder` varchar(25) NOT NULL DEFAULT '',		
		PRIMARY KEY (`layerid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_layer');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_part` (
		`partid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`categoryid` int(10) unsigned NOT NULL DEFAULT '0',
		`signaturestyleid` int(10) unsigned NOT NULL DEFAULT '0',
		`layerid` int(10) unsigned NOT NULL DEFAULT '0',
		`displayorder` int(10) unsigned NOT NULL DEFAULT '0',
		`price` int(10) unsigned NOT NULL DEFAULT '10',
		`filename` mediumtext,
		`permissions` mediumtext,
		PRIMARY KEY (`partid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_part');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_region` (
		`regionid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`signaturestyleid` int(10) unsigned NOT NULL DEFAULT '0',		
		`xcoord` int(10) unsigned NOT NULL DEFAULT '0',
		`ycoord` int(10) unsigned NOT NULL DEFAULT '0',
		`stringlength` int(10) unsigned NOT NULL DEFAULT '0',		
		`fontid` int(10) unsigned NOT NULL DEFAULT '0',		
		`fontsize` tinyint(1) unsigned NOT NULL DEFAULT '3',		
		`fontcolor` varchar(7) NOT NULL DEFAULT '',
		`fontweight` tinyint(1) unsigned NOT NULL DEFAULT '0',		
		`regiontext` MEDIUMTEXT NULL,
		PRIMARY KEY (`regionid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_region');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsignatures_signaturestyle` (
		`signaturestyleid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`title` varchar(250) NOT NULL DEFAULT '',
		`active` enum('0','1') NOT NULL DEFAULT '1',
		`displayorder` int(10) unsigned NOT NULL DEFAULT '0',
		`description` mediumtext,
		`permissions` mediumtext,
		PRIMARY KEY (`signaturestyleid`)
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_vbsignatures_signaturestyle');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_category` 
		(`categoryid`, `title`, `active`, `displayorder`, `description`, `permissions`)
	VALUES
		(1, 'Base', '1', 10, 'The base signature part.', NULL),
		(2, 'Frame', '1', 40, 'The signature frame.', NULL),
		(3, 'Effects', '1', 50, 'The signature effects', NULL),
		(4, 'Forum Icons', '1', 60, 'The forum icons.', NULL),
		(5, 'Text Region', '1', 70, 'The text region.', NULL),
		(6, 'Avatar Icon', '1', 80, 'The avatar icon.', NULL),
		(7, 'Base Shadow', '1', 30, 'The base shadow.', NULL),
		(8, 'Blood', '1', 20, 'A cool blood-drop effect.', NULL),
		(9, 'Zodiac Sign', '1', 90, 'Add a cool Zodiac Sign to your signature.', NULL)
");
self::report('Populated Table', 'dbtech_vbsignatures_category');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_font`
		(`fontid`, `title`, `active`, `displayorder`, `fontfile_0`, `fontfile_1`, `fontfile_2`, `fontfile_3`, `cancustom`)
	VALUES
		(1, 'Default Font', '1', 10, 'dbtech/vbsignatures/fonts/default_0', 'dbtech/vbsignatures/fonts/default_1', 'dbtech/vbsignatures/fonts/default_2', 'dbtech/vbsignatures/fonts/default_3', '1'),
		(2, 'Edmunds', '0', 20, 'images/regimage/fonts/edmunds', 'images/regimage/fonts/edmunds', 'images/regimage/fonts/edmunds', 'images/regimage/fonts/edmunds', '1'),
		(3, 'Effloresce Bold', '0', 30, 'images/regimage/fonts/EFFLB___', 'images/regimage/fonts/EFFLB___', 'images/regimage/fonts/EFFLB___', 'images/regimage/fonts/EFFLB___', '1'),
		(4, 'Highway to Heck', '0', 40, 'images/regimage/fonts/HECK', 'images/regimage/fonts/HECK', 'images/regimage/fonts/HECK', 'images/regimage/fonts/HECK', '1'),
		(5, 'Minya Nouvelle', '0', 50, 'images/regimage/fonts/MINYN___', 'images/regimage/fonts/MINYN___', 'images/regimage/fonts/MINYN___', 'images/regimage/fonts/MINYN___', '1'),
		(6, 'Spongy', '0', 60, 'images/regimage/fonts/SPONGY', 'images/regimage/fonts/SPONGY', 'images/regimage/fonts/SPONGY', 'images/regimage/fonts/SPONGY', '1'),
		(7, 'Wet Pet', '0', 70, 'images/regimage/fonts/WetPet', 'images/regimage/fonts/WetPet', 'images/regimage/fonts/WetPet', 'images/regimage/fonts/WetPet', '1')
");
self::report('Populated Table', 'dbtech_vbsignatures_font');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_layer` 
		(`layerid`, `title`, `active`, `displayorder`, `folder`)
	VALUES
		(1, 'Signature Base', '1', 10, ''),
		(2, 'Frame', '1', 40, 'frame'),
		(3, 'Effects', '1', 50, 'effects'),
		(4, 'Forum Icons', '1', 60, 'options'),
		(5, 'Text Region', '1', 70, 'region'),
		(6, 'Avatar Icon', '1', 80, 'avatar'),
		(7, 'Base Shadow', '1', 30, 'baseshadow'),
		(8, 'Blood', '1', 20, 'blood'),
		(9, 'Zodiac Sign', '1', 90, 'zodiac')
");
self::report('Populated Table', 'dbtech_vbsignatures_layer');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_part` 
		(`partid`, `title`, `active`, `categoryid`, `signaturestyleid`, `layerid`, `displayorder`, `price`, `filename`, `permissions`)
	VALUES
		(2, 'DragonByte Tech Logo 1', '1', 6, 1, 6, 10, 10, 'avatar-1.png', NULL),
		(3, 'DragonByte Tech Logo 2', '1', 6, 1, 6, 20, 10, 'avatar-2.png', NULL),
		(4, 'DragonByte Tech Logo 3', '1', 6, 1, 6, 30, 10, 'avatar-3.png', NULL),
		(5, 'DragonByte Tech Logo 4', '1', 6, 1, 6, 40, 10, 'avatar-4.png', NULL),
		(6, 'DragonByte Tech Logo 5', '1', 6, 1, 6, 50, 10, 'avatar-5.png', NULL),
		(7, 'DragonByte Tech Logo 6', '1', 6, 1, 6, 60, 10, 'avatar-6.png', NULL),
		(8, 'vBulletin Logo 1', '1', 6, 1, 6, 70, 10, 'avatar-7.png', NULL),
		(41, 'Base 4', '1', 1, 1, 1, 40, 10, 'base-4.png', NULL),
		(40, 'Base 3', '1', 1, 1, 1, 30, 10, 'base-3.png', NULL),
		(39, 'Base 2', '1', 1, 1, 1, 20, 10, 'base-2.png', NULL),
		(38, 'Base 12', '1', 1, 1, 1, 120, 10, 'base-12.png', NULL),
		(37, 'Base 11', '1', 1, 1, 1, 110, 10, 'base-11.png', NULL),
		(36, 'Base 10', '1', 1, 1, 1, 100, 10, 'base-10.png', NULL),
		(15, 'Lightning (Gold)', '1', 3, 1, 3, 10, 10, 'effect-1.png', NULL),
		(16, 'Lightning (Green)', '1', 3, 1, 3, 20, 10, 'effect-2.png', NULL),
		(17, 'Lightning (Red)', '1', 3, 1, 3, 30, 10, 'effect-3.png', NULL),
		(18, 'Lightning (Cyan)', '1', 3, 1, 3, 40, 10, 'effect-4.png', NULL),
		(19, 'Lightning (Purple)', '1', 3, 1, 3, 50, 10, 'effect-5.png', NULL),
		(20, 'Frame (Gold)', '1', 2, 1, 2, 10, 10, 'frame-1.png', NULL),
		(21, 'Frame (Green / Black)', '1', 2, 1, 2, 100, 10, 'frame-10.png', NULL),
		(22, 'Frame (Red / Black)', '1', 2, 1, 2, 110, 10, 'frame-11.png', NULL),
		(23, 'Frame (Cyan / Black)', '1', 2, 1, 2, 120, 10, 'frame-12.png', NULL),
		(24, 'Frame (Silver / Gray)', '1', 2, 1, 2, 20, 10, 'frame-2.png', NULL),
		(25, 'Frame (Dark Yellow)', '1', 2, 1, 2, 30, 10, 'frame-3.png', NULL),
		(26, 'Frame (Orange)', '1', 2, 1, 2, 40, 10, 'frame-4.png', NULL),
		(27, 'Frame (Metallic)', '1', 2, 1, 2, 50, 10, 'frame-5.png', NULL),
		(28, 'Frame (Red / Metallic)', '1', 2, 1, 2, 60, 10, 'frame-6.png', NULL),
		(29, 'Frame (Orange / Black)', '1', 2, 1, 2, 70, 10, 'frame-7.png', NULL),
		(30, 'Frame (Purple / Black)', '1', 2, 1, 2, 80, 10, 'frame-8.png', NULL),
		(31, 'Frame (Yellow / Black)', '1', 2, 1, 2, 90, 10, 'frame-9.png', NULL),
		(32, 'vBulletin Icon 1', '1', 4, 1, 4, 10, 10, 'vb.png', NULL),
		(33, 'xenForo Icon 1', '1', 4, 1, 4, 20, 10, 'xf.png', NULL),
		(64, 'Base 9', '1', 1, 1, 1, 90, 10, 'base-9.png', NULL),
		(63, 'Base 8', '1', 1, 1, 1, 80, 10, 'base-8.png', NULL),
		(62, 'Base 7', '1', 1, 1, 1, 70, 10, 'base-7.png', NULL),
		(61, 'Base 6', '1', 1, 1, 1, 60, 10, 'base-6.png', NULL),
		(60, 'Base 5', '1', 1, 1, 1, 50, 10, 'base-5.png', NULL),
		(53, 'Base 1', '1', 1, 1, 1, 10, 10, 'base-1.png', NULL),
		(65, 'Base Shadow (Yellow)', '1', 7, 1, 7, 10, 10, 'shadow-1y.png', NULL),
		(66, 'Base Shadow (White)', '1', 7, 1, 7, 20, 10, 'shadow-2w.png', NULL),
		(67, 'Base Shadow (Red)', '1', 7, 1, 7, 30, 10, 'shadow-3r.png', NULL),
		(68, 'Base Shadow (Blue)', '1', 7, 1, 7, 40, 10, 'shadow-4b.png', NULL),
		(69, 'Base Shadow (Purple)', '1', 7, 1, 7, 50, 10, 'shadow-5p.png', NULL),
		(70, 'Base Shadow (Green)', '1', 7, 1, 7, 60, 10, 'shadow-6g.png', NULL),
		(71, 'Blood (Blue)', '1', 8, 1, 8, 10, 10, 'blood-blue.png', NULL),
		(72, 'Blood (Green)', '1', 8, 1, 8, 20, 10, 'blood-green.png', NULL),
		(73, 'Blood (Mixed)', '1', 8, 1, 8, 30, 10, 'blood-mix.png', NULL),
		(74, 'Blood (Purple)', '1', 8, 1, 8, 40, 10, 'blood-purpur.png', NULL),
		(75, 'Blood (Red)', '1', 8, 1, 8, 50, 10, 'blood-red.png', NULL),
		(76, 'Blood (Yellow)', '1', 8, 1, 8, 60, 10, 'blood-yellow.png', NULL),
		(77, 'Laser (Red)', '1', 3, 1, 3, 110, 10, 'lazer-1.png', NULL),
		(78, 'Laser (Cyan)', '1', 3, 1, 3, 120, 10, 'lazer-2.png', NULL),
		(80, 'Laser (Green)', '1', 3, 1, 3, 140, 10, 'lazer-4.png', NULL),
		(82, 'Frame (Dark Blue)', '1', 2, 1, 2, 130, 10, 'frame-13.png', NULL),
		(83, 'Frame (Yellow / Green)', '1', 2, 1, 2, 140, 10, 'frame-14.png', NULL),
		(84, 'Text Region (Black)', '1', 5, 1, 5, 10, 10, 'textbase-1.png', NULL),
		(85, 'Text Region (Orange 2)', '1', 5, 1, 5, 100, 10, 'textbase-10.png', NULL),
		(86, 'Text Region (Cyan)', '1', 5, 1, 5, 110, 10, 'textbase-11.png', NULL),
		(87, 'Text Region (Green)', '1', 5, 1, 5, 120, 10, 'textbase-12.png', NULL),
		(88, 'Text Region (Gold)', '1', 5, 1, 5, 20, 10, 'textbase-2.png', NULL),
		(89, 'Text Region (Brown)', '1', 5, 1, 5, 30, 10, 'textbase-3.png', NULL),
		(90, 'Text Region (Dark Green)', '1', 5, 1, 5, 40, 10, 'textbase-4.png', NULL),
		(91, 'Text Region (Metallic)', '1', 5, 1, 5, 50, 10, 'textbase-5.png', NULL),
		(92, 'Text Region (Red / Black)', '1', 5, 1, 5, 60, 10, 'textbase-6.png', NULL),
		(93, 'Text Region (Orange 1)', '1', 5, 1, 5, 70, 10, 'textbase-7.png', NULL),
		(94, 'Text Region (Red)', '1', 5, 1, 5, 80, 10, 'textbase-8.png', NULL),
		(95, 'Text Region (Purple)', '1', 5, 1, 5, 90, 10, 'textbase-9.png', NULL),
		(96, 'Aquarius (Gold)', '1', 9, 1, 9, 10, 10, 'gold-1.png', NULL),
		(97, 'Scorpio (Gold)', '1', 9, 1, 9, 100, 10, 'gold-10.png', NULL),
		(98, 'Taurus (Gold)', '1', 9, 1, 9, 110, 10, 'gold-11.png', NULL),
		(99, 'Virgo (Gold)', '1', 9, 1, 9, 120, 10, 'gold-12.png', NULL),
		(100, 'Aries (Gold)', '1', 9, 1, 9, 20, 10, 'gold-2.png', NULL),
		(101, 'Cancer (Gold)', '1', 9, 1, 9, 30, 10, 'gold-3.png', NULL),
		(102, 'Capricorn (Gold)', '1', 9, 1, 9, 40, 10, 'gold-4.png', NULL),
		(103, 'Pisces (Gold)', '1', 9, 1, 9, 50, 10, 'gold-5.png', NULL),
		(104, 'Leo (Gold)', '1', 9, 1, 9, 60, 10, 'gold-6.png', NULL),
		(105, 'Libra (Gold)', '1', 9, 1, 9, 70, 10, 'gold-7.png', NULL),
		(106, 'Gemini (Gold)', '1', 9, 1, 9, 80, 10, 'gold-8.png', NULL),
		(107, 'Saggitarius (Gold)', '1', 9, 1, 9, 90, 10, 'gold-9.png', NULL),
		(108, 'Aquarius (Silver)', '1', 9, 1, 9, 210, 10, 'silver-1.png', NULL),
		(109, 'Scorpio (Silver)', '1', 9, 1, 9, 300, 10, 'silver-10.png', NULL),
		(110, 'Taurus (Silver)', '1', 9, 1, 9, 310, 10, 'silver-11.png', NULL),
		(111, 'Virgo (Silver)', '1', 9, 1, 9, 320, 10, 'silver-12.png', NULL),
		(112, 'Aries (Silver)', '1', 9, 1, 9, 220, 10, 'silver-2.png', NULL),
		(113, 'Cancer (Silver)', '1', 9, 1, 9, 230, 10, 'silver-3.png', NULL),
		(114, 'Capricorn (Silver)', '1', 9, 1, 9, 240, 10, 'silver-4.png', NULL),
		(115, 'Pisces (Silver)', '1', 9, 1, 9, 250, 10, 'silver-5.png', NULL),
		(116, 'Leo (Silver)', '1', 9, 1, 9, 260, 10, 'silver-6.png', NULL),
		(117, 'Libra (Silver)', '1', 9, 1, 9, 270, 10, 'silver-7.png', NULL),
		(118, 'Gemini (Silver)', '1', 9, 1, 9, 280, 10, 'silver-8.png', NULL),
		(119, 'Saggitarius (Silver)', '1', 9, 1, 9, 290, 10, 'silver-9.png', NULL),
		(120, 'Laser (Purple)', '1', 3, 1, 3, 130, 10, 'lazer-3.png', NULL),
		(121, 'Laser (Yellow)', '1', 3, 1, 3, 150, 10, 'lazer-5.png', NULL)
");
self::report('Populated Table', 'dbtech_vbsignatures_part');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_region` 
		(`regionid`, `title`, `active`, `signaturestyleid`, `xcoord`, `ycoord`, `stringlength`, `fontid`, `fontsize`, `fontweight`, `fontcolor`, `regiontext`)
	VALUES
		(5, 'Forum Name', '1', 1, 83, 62, 27, 1, 16, 0, '#FFFFFF', 'DragonByte Technologies'),
		(4, 'Forum Version', '1', 1, 84, 87, 6, 1, 9, 1, '#FFFFFF', '4.1.12')
");
self::report('Populated Table', 'dbtech_vbsignatures_region');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "dbtech_vbsignatures_signaturestyle` 
		(`signaturestyleid`, `title`, `active`, `displayorder`, `description`, `permissions`)
	VALUES
		(1, 'Default Signature Style', '1', 10, 'The default signature style.', NULL)
");
self::report('Populated Table', 'dbtech_vbsignatures_signaturestyle');